/** @file   FlameThrowerBullet.cpp
 * @brief   Implementation of FlameThrowerBullet class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/08 21:47:23 $
 * @author  Tomi Lamminsaari
 */

#include "FlameThrowerBullet.h"
#include "www_map.h"
#include "gameanims.h"
#include "AnimId.h"
using namespace eng2d;

namespace WeWantWar {

///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
FlameThrowerBullet::FlameThrowerBullet( GameObject* aShooter, const Vec2D& aPos ) :
  Bullet( aShooter, Bullet::EFlameThrower, aPos )
{
  iAnimation = GameAnims::findAnimation( AnimId::KFireFlameThrower );
}



/** Destructor.
 */
FlameThrowerBullet::~FlameThrowerBullet()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Draws this bullet.
 */
void FlameThrowerBullet::redraw( BITMAP* aBitmap ) const
{
  AnimFrame frame = iAnimation.currentFrame();
  int posX = iPosition.intX() - Map::scrollX;
  int posY = iPosition.intY() - Map::scrollY;
  RLE_SPRITE* gfx = frame.asRleSprite();
  posX -= gfx->w / 2;
  posY -= gfx->h / 2;
  SetBlendFunction( frame.iFrameBlend, frame.iFrameAlpha );
  draw_trans_rle_sprite( aBitmap, gfx, posX, posY );
}

};  // end of namespace
